import os, stat
from os.path import basename
from optparse import OptionParser

if __name__ == '__main__':
	parser = OptionParser()
	parser.add_option("-d", "--directory", dest="directory", default=".")
	parser.add_option("-o", "--output", dest="output_file", default="pdt_static.c")

	(options, args) = parser.parse_args()
	
	print '\n'
	print 'Generating ' + options.output_file + ':'

	os.chmod( options.output_file, stat.S_IWRITE )
	os.unlink( options.output_file )
	
	#open pdt_static file to writing
	file_w = open(options.output_file, 'wb')
	file_w.write('#ifdef CONFIG_USE_STATIC_DESCRIPTOR_TABLES\n')
	
	#run on all PDT files
	for f in os.listdir(options.directory):
		#print f
		if f.startswith('INTC_pdt_') and not f.endswith('.xml'):
			print '\tAdding ' + f
			file_r = open(options.directory + "\\" + basename(f), 'rb')
			file_w.write('#if defined (' + basename(f).split('pdt_')[1] + ')\nuint8_t main_pdt_blob[] = {\n')
			#read byte after  byte
			byte = file_r.read(1)
			while byte != '':
				index = 16
				while index > 0 and byte != '':
					file_w.write(hex(ord(byte)) + ',')
					byte = file_r.read(1)
					index = index - 1
				file_w.write('\n')
			file_w.write('};\n#endif\n')
	file_w.write('\n#endif')

	print "Done."
